/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.subscriptions;

import io.moquette.spi.ClientSession;
import io.moquette.spi.impl.SessionsRepository;
import io.moquette.spi.impl.subscriptions.CNode;
import io.moquette.spi.impl.subscriptions.INode;
import io.moquette.spi.impl.subscriptions.ISubscriptionsDirectory;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.TNode;
import io.moquette.spi.impl.subscriptions.Token;
import io.moquette.spi.impl.subscriptions.Topic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTrieSubscriptionDirectory
implements ISubscriptionsDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(CTrieSubscriptionDirectory.class);
    private static final Token ROOT = new Token("root");
    private static final INode NO_PARENT = null;
    INode root;
    private volatile SessionsRepository sessionsRepository;

    @Override
    public void init(SessionsRepository sessionsRepository) {
        LOG.info("Initializing CTrie");
        CNode mainNode = new CNode();
        mainNode.token = ROOT;
        this.root = new INode(mainNode);
        LOG.info("Initializing subscriptions store...");
        this.sessionsRepository = sessionsRepository;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reloading all stored subscriptions. SubscriptionTree = {}", (Object)this.dumpTree());
        }
        for (ClientSession session : this.sessionsRepository.getAllSessions()) {
            for (Subscription subscription : session.getSubscriptions()) {
                LOG.info("Re-subscribing client to topic CId={}, topicFilter={}", (Object)subscription.clientId, (Object)subscription.topicFilter);
                this.add(subscription);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stored subscriptions have been reloaded. SubscriptionTree = {}", (Object)this.dumpTree());
        }
    }

    Optional<CNode> lookup(Topic topic) {
        INode inode = this.root;
        Token token = topic.headToken();
        while (!topic.isEmpty() && inode.mainNode().anyChildrenMatch(token)) {
            topic = topic.exceptHeadToken();
            inode = inode.mainNode().childOf(token);
            token = topic.headToken();
        }
        if (inode == null || !topic.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(inode.mainNode());
    }

    @Override
    public List<Subscription> matches(Topic topic) {
        return new ArrayList<Subscription>(this.match(topic));
    }

    Set<Subscription> match(Topic topic) {
        Set<Subscription> matchingSubs = this.recursiveMatch(topic, this.root);
        HashMap<String, Subscription> subsForClient = new HashMap<String, Subscription>();
        for (Subscription matchingSub : matchingSubs) {
            Subscription existingSub = (Subscription)subsForClient.get(matchingSub.clientId);
            ClientSession subscribedSession = this.sessionsRepository.sessionForClient(matchingSub.clientId);
            if (subscribedSession == null) continue;
            Subscription sub = subscribedSession.findSubscriptionByTopicFilter(matchingSub);
            if (sub == null) {
                String excpMesg = String.format("Target session %s is connected but doesn't anymore subscribed to %s", matchingSub.clientId, matchingSub);
                throw new IllegalStateException(excpMesg);
            }
            if (existingSub != null && !existingSub.qosLessThan(sub)) continue;
            subsForClient.put(sub.clientId, sub);
        }
        return new HashSet<Subscription>(subsForClient.values());
    }

    Set<Subscription> recursiveMatch(Topic topic, INode inode) {
        CNode cnode = inode.mainNode();
        if (cnode.token == Token.MULTI) {
            return cnode.subscriptions;
        }
        if (topic.isEmpty()) {
            return Collections.emptySet();
        }
        if (cnode instanceof TNode) {
            return Collections.emptySet();
        }
        Token token = topic.headToken();
        if (cnode.token != Token.SINGLE && !cnode.token.equals(token) && cnode.token != ROOT) {
            return Collections.emptySet();
        }
        Topic remainingTopic = cnode.token == ROOT ? topic : topic.exceptHeadToken();
        HashSet<Subscription> subscriptions = new HashSet<Subscription>();
        if (remainingTopic.isEmpty()) {
            subscriptions.addAll(cnode.subscriptions);
        }
        for (INode subInode : cnode.allChildren()) {
            subscriptions.addAll(this.recursiveMatch(remainingTopic, subInode));
        }
        return subscriptions;
    }

    public Action cleanTomb(INode inode, INode iParent) {
        CNode updatedCnode = iParent.mainNode().copy();
        updatedCnode.remove(inode);
        return iParent.compareAndSet(iParent.mainNode(), updatedCnode) ? Action.OK : Action.REPEAT;
    }

    @Override
    public void add(Subscription newSubscription) {
        Action res;
        while ((res = this.insert(newSubscription.clientId, newSubscription.topicFilter, this.root, newSubscription.topicFilter)) == Action.REPEAT) {
        }
    }

    private Action insert(String clientId, Topic topic, INode inode, Topic fullpath) {
        Token token = topic.headToken();
        if (!topic.isEmpty() && inode.mainNode().anyChildrenMatch(token)) {
            Topic remainingTopic = topic.exceptHeadToken();
            INode nextInode = inode.mainNode().childOf(token);
            return this.insert(clientId, remainingTopic, nextInode, fullpath);
        }
        if (topic.isEmpty()) {
            return this.insertSubscription(clientId, fullpath, inode);
        }
        return this.createNodeAndInsertSubscription(clientId, topic, inode, fullpath);
    }

    private Action insertSubscription(String clientId, Topic topic, INode inode) {
        CNode updatedCnode;
        CNode cnode = inode.mainNode();
        if (inode.compareAndSet(cnode, updatedCnode = cnode.copy().addSubscription(clientId, topic))) {
            return Action.OK;
        }
        return Action.REPEAT;
    }

    private Action createNodeAndInsertSubscription(String clientId, Topic topic, INode inode, Topic fullpath) {
        INode newInode = this.createPathRec(clientId, topic, fullpath);
        CNode cnode = inode.mainNode();
        CNode updatedCnode = cnode.copy();
        updatedCnode.add(newInode);
        return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
    }

    private INode createLeafNodes(String clientId, Topic fullpath, Token token) {
        CNode newLeafCnode = new CNode();
        newLeafCnode.token = token;
        newLeafCnode.addSubscription(clientId, fullpath);
        return new INode(newLeafCnode);
    }

    private INode createPathRec(String clientId, Topic topic, Topic fullpath) {
        Topic remainingTopic = topic.exceptHeadToken();
        if (!remainingTopic.isEmpty()) {
            INode inode = this.createPathRec(clientId, remainingTopic, fullpath);
            CNode cnode = new CNode();
            cnode.token = topic.headToken();
            cnode.add(inode);
            return new INode(cnode);
        }
        return this.createLeafNodes(clientId, fullpath, topic.headToken());
    }

    @Override
    public void removeSubscription(Topic topic, String clientID) {
        Action res;
        while ((res = this.remove(clientID, topic, this.root, NO_PARENT)) == Action.REPEAT) {
        }
    }

    private Action remove(String clientId, Topic topic, INode inode, INode iParent) {
        Token token = topic.headToken();
        if (!topic.isEmpty() && inode.mainNode().anyChildrenMatch(token)) {
            Topic remainingTopic = topic.exceptHeadToken();
            INode nextInode = inode.mainNode().childOf(token);
            return this.remove(clientId, remainingTopic, nextInode, inode);
        }
        CNode cnode = inode.mainNode();
        if (cnode instanceof TNode) {
            return Action.OK;
        }
        if (cnode.containsOnly(clientId) && topic.isEmpty() && cnode.allChildren().isEmpty()) {
            if (inode == this.root) {
                return inode.compareAndSet(cnode, inode.mainNode().copy()) ? Action.OK : Action.REPEAT;
            }
            TNode tnode = new TNode();
            return inode.compareAndSet(cnode, tnode) ? this.cleanTomb(inode, iParent) : Action.REPEAT;
        }
        if (cnode.contains(clientId) && topic.isEmpty()) {
            CNode updatedCnode = cnode.copy();
            updatedCnode.removeSubscriptionsFor(clientId);
            return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
        }
        return Action.OK;
    }

    @Override
    public int size() {
        SubscriptionCounterVisitor visitor = new SubscriptionCounterVisitor();
        this.dfsVisit(this.root, visitor, 0);
        return visitor.getResult();
    }

    @Override
    public String dumpTree() {
        DumpTreeVisitor visitor = new DumpTreeVisitor();
        this.dfsVisit(this.root, visitor, 0);
        return visitor.getResult();
    }

    private void dfsVisit(INode node, IVisitor<?> visitor, int deep) {
        if (node == null) {
            return;
        }
        visitor.visit(node.mainNode(), deep);
        ++deep;
        for (INode child : node.mainNode().allChildren()) {
            this.dfsVisit(child, visitor, deep);
        }
    }

    private class SubscriptionCounterVisitor
    implements IVisitor<Integer> {
        AtomicInteger accumulator = new AtomicInteger(0);

        private SubscriptionCounterVisitor() {
        }

        @Override
        public void visit(CNode node, int deep) {
            this.accumulator.addAndGet(node.subscriptions.size());
        }

        @Override
        public Integer getResult() {
            return this.accumulator.get();
        }
    }

    private static enum Action {
        OK,
        REPEAT;

    }

    private class DumpTreeVisitor
    implements IVisitor<String> {
        String s = "";

        private DumpTreeVisitor() {
        }

        @Override
        public void visit(CNode node, int deep) {
            String indentTabs = this.indentTabs(deep);
            this.s = this.s + indentTabs + (node.token == null ? "''" : node.token.toString()) + this.prettySubscriptions(node) + "\n";
        }

        private String prettySubscriptions(CNode node) {
            if (node instanceof TNode) {
                return "TNode";
            }
            if (node.subscriptions.isEmpty()) {
                return "";
            }
            StringBuilder subScriptionsStr = new StringBuilder(" ~~[");
            int counter = 0;
            for (Subscription couple : node.subscriptions) {
                subScriptionsStr.append("{filter=").append(couple.topicFilter).append(", ").append("client='").append(couple.clientId).append("'}");
                if (++counter >= node.subscriptions.size()) continue;
                subScriptionsStr.append(";");
            }
            return subScriptionsStr.append("]").toString();
        }

        private String indentTabs(int deep) {
            StringBuilder s = new StringBuilder();
            if (deep > 0) {
                s.append("    ");
                for (int i = 0; i < deep - 1; ++i) {
                    s.append("| ");
                }
                s.append("|-");
            }
            return s.toString();
        }

        @Override
        public String getResult() {
            return this.s;
        }
    }

    private static interface IVisitor<T> {
        public void visit(CNode var1, int var2);

        public T getResult();
    }
}

