/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.security;

import com.zaxxer.hikari.HikariDataSource;
import io.moquette.server.config.IConfig;
import io.moquette.spi.security.IAuthenticator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBAuthenticator
implements IAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(DBAuthenticator.class);
    private final MessageDigest messageDigest;
    private HikariDataSource dataSource;
    private String sqlQuery;

    public DBAuthenticator(IConfig conf) {
        this(conf.getProperty("authenticator.db.driver", ""), conf.getProperty("authenticator.db.url", ""), conf.getProperty("authenticator.db.query", ""), conf.getProperty("authenticator.db.digest", ""));
    }

    public DBAuthenticator(String driver, String jdbcUrl, String sqlQuery, String digestMethod) {
        this.sqlQuery = sqlQuery;
        this.dataSource = new HikariDataSource();
        this.dataSource.setJdbcUrl(jdbcUrl);
        try {
            this.messageDigest = MessageDigest.getInstance(digestMethod);
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOG.error(String.format("Can't find %s for password encoding", digestMethod), (Throwable)nsaex);
            throw new RuntimeException(nsaex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean checkValid(String clientId, String username, byte[] password) {
        if (username == null || password == null) {
            LOG.info("username or password was null");
            return false;
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            preparedStatement = conn.prepareStatement(this.sqlQuery);
            preparedStatement.setString(1, username);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String foundPwq = resultSet.getString(1);
                this.messageDigest.update(password);
                byte[] digest = this.messageDigest.digest();
                String encodedPasswd = new String(Hex.encodeHex((byte[])digest));
                boolean bl = foundPwq.equals(encodedPasswd);
                return bl;
            }
        }
        catch (SQLException sqlex) {
            LOG.error("Error quering DB for username: {}", (Object)username, (Object)sqlex);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Error releasing connection to the datasource", (Object)username, (Object)e);
            }
        }
        return false;
    }
}

