/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.security;

import io.moquette.spi.impl.security.Authorization;
import io.moquette.spi.impl.subscriptions.Topic;
import io.moquette.spi.security.IAuthorizator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AuthorizationsCollector
implements IAuthorizator {
    private List<Authorization> m_globalAuthorizations = new ArrayList<Authorization>();
    private List<Authorization> m_patternAuthorizations = new ArrayList<Authorization>();
    private Map<String, List<Authorization>> m_userAuthorizations = new HashMap<String, List<Authorization>>();
    private boolean m_parsingUsersSpecificSection;
    private boolean m_parsingPatternSpecificSection;
    private String m_currentUser = "";

    AuthorizationsCollector() {
    }

    static final AuthorizationsCollector emptyImmutableCollector() {
        AuthorizationsCollector coll = new AuthorizationsCollector();
        coll.m_globalAuthorizations = Collections.emptyList();
        coll.m_patternAuthorizations = Collections.emptyList();
        coll.m_userAuthorizations = Collections.emptyMap();
        return coll;
    }

    void parse(String line) throws ParseException {
        Authorization acl = this.parseAuthLine(line);
        if (acl == null) {
            return;
        }
        if (this.m_parsingUsersSpecificSection) {
            if (!this.m_userAuthorizations.containsKey(this.m_currentUser)) {
                this.m_userAuthorizations.put(this.m_currentUser, new ArrayList());
            }
            List<Authorization> userAuths = this.m_userAuthorizations.get(this.m_currentUser);
            userAuths.add(acl);
        } else if (this.m_parsingPatternSpecificSection) {
            this.m_patternAuthorizations.add(acl);
        } else {
            this.m_globalAuthorizations.add(acl);
        }
    }

    protected Authorization parseAuthLine(String line) throws ParseException {
        String keyword;
        String[] tokens = line.split("\\s+");
        switch (keyword = tokens[0].toLowerCase()) {
            case "topic": {
                return this.createAuthorization(line, tokens);
            }
            case "user": {
                this.m_parsingUsersSpecificSection = true;
                this.m_currentUser = tokens[1];
                this.m_parsingPatternSpecificSection = false;
                return null;
            }
            case "pattern": {
                this.m_parsingUsersSpecificSection = false;
                this.m_currentUser = "";
                this.m_parsingPatternSpecificSection = true;
                return this.createAuthorization(line, tokens);
            }
        }
        throw new ParseException(String.format("invalid line definition found %s", line), 1);
    }

    private Authorization createAuthorization(String line, String[] tokens) throws ParseException {
        if (tokens.length > 2) {
            try {
                Authorization.Permission permission = Authorization.Permission.valueOf(tokens[1].toUpperCase());
                String tp = line.substring(line.indexOf(tokens[2]));
                Topic topic = new Topic(tp);
                return new Authorization(topic, permission);
            }
            catch (IllegalArgumentException iaex) {
                throw new ParseException("invalid permission token", 1);
            }
        }
        Topic topic = new Topic(tokens[1]);
        return new Authorization(topic);
    }

    @Override
    public boolean canWrite(Topic topic, String user, String client) {
        return this.canDoOperation(topic, Authorization.Permission.WRITE, user, client);
    }

    @Override
    public boolean canRead(Topic topic, String user, String client) {
        return this.canDoOperation(topic, Authorization.Permission.READ, user, client);
    }

    private boolean canDoOperation(Topic topic, Authorization.Permission permission, String username, String client) {
        List<Authorization> auths;
        if (this.matchACL(this.m_globalAuthorizations, topic, permission)) {
            return true;
        }
        if (this.isNotEmpty(client) || this.isNotEmpty(username)) {
            for (Authorization auth : this.m_patternAuthorizations) {
                Topic substitutedTopic = new Topic(auth.topic.toString().replace("%c", client).replace("%u", username));
                if (!auth.grant(permission) || !topic.match(substitutedTopic)) continue;
                return true;
            }
        }
        return this.isNotEmpty(username) && this.m_userAuthorizations.containsKey(username) && this.matchACL(auths = this.m_userAuthorizations.get(username), topic, permission);
    }

    private boolean matchACL(List<Authorization> auths, Topic topic, Authorization.Permission permission) {
        for (Authorization auth : auths) {
            if (!auth.grant(permission) || !topic.match(auth.topic)) continue;
            return true;
        }
        return false;
    }

    private boolean isNotEmpty(String client) {
        return client != null && !client.isEmpty();
    }

    public boolean isEmpty() {
        return this.m_globalAuthorizations.isEmpty();
    }
}

