/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.interception.InterceptHandler;
import io.moquette.server.ConnectionDescriptorStore;
import io.moquette.server.Server;
import io.moquette.server.config.IConfig;
import io.moquette.server.config.IResourceLoader;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.IStore;
import io.moquette.spi.ISubscriptionsStore;
import io.moquette.spi.impl.BrokerInterceptor;
import io.moquette.spi.impl.ProtocolProcessor;
import io.moquette.spi.impl.SessionsRepository;
import io.moquette.spi.impl.security.ACLFileParser;
import io.moquette.spi.impl.security.AcceptAllAuthenticator;
import io.moquette.spi.impl.security.DenyAllAuthorizator;
import io.moquette.spi.impl.security.PermitAllAuthorizator;
import io.moquette.spi.impl.security.ResourceAuthenticator;
import io.moquette.spi.impl.subscriptions.CTrieSubscriptionDirectory;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.security.IAuthenticator;
import io.moquette.spi.security.IAuthorizator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolProcessorBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolProcessorBootstrapper.class);
    public static final String INMEMDB_STORE_CLASS = "io.moquette.persistence.MemoryStorageService";
    private ISessionsStore m_sessionsStore;
    private ISubscriptionsStore subscriptionsStore;
    private Runnable storeShutdown;
    private final ProtocolProcessor m_processor = new ProtocolProcessor();
    private ConnectionDescriptorStore connectionDescriptors;

    public ProtocolProcessor init(IConfig props, List<? extends InterceptHandler> embeddedObservers, IAuthenticator authenticator, IAuthorizator authorizator, Server server) {
        InterceptHandler handler;
        LOG.info("Initializing messages and sessions stores...");
        String storageClassName = props.getProperty("storage_class", INMEMDB_STORE_CLASS);
        if (storageClassName == null || storageClassName.isEmpty()) {
            LOG.error("storage_class property not defined");
            throw new IllegalArgumentException("Can't find a valid persistence layer");
        }
        final IStore store = this.instantiateConfiguredStore(storageClassName, props, server.getScheduler());
        if (store == null) {
            throw new IllegalArgumentException("Can't start the persistence layer");
        }
        store.initStore();
        IMessagesStore messagesStore = store.messagesStore();
        this.m_sessionsStore = store.sessionsStore();
        SessionsRepository sessionsRepository = new SessionsRepository(this.m_sessionsStore, server.getScheduler());
        sessionsRepository.init();
        this.subscriptionsStore = this.m_sessionsStore.subscriptionStore();
        this.storeShutdown = new Runnable(){

            @Override
            public void run() {
                store.close();
            }
        };
        LOG.info("Configuring message interceptors...");
        ArrayList<InterceptHandler> observers = new ArrayList<InterceptHandler>(embeddedObservers);
        String interceptorClassName = props.getProperty("intercept.handler");
        if (interceptorClassName != null && !interceptorClassName.isEmpty() && (handler = this.loadClass(interceptorClassName, InterceptHandler.class, Server.class, server)) != null) {
            observers.add(handler);
        }
        BrokerInterceptor interceptor = new BrokerInterceptor(props, observers);
        LOG.info("Initializing subscriptions store...");
        CTrieSubscriptionDirectory subscriptions = new CTrieSubscriptionDirectory();
        subscriptions.init(sessionsRepository);
        LOG.info("Configuring MQTT authenticator...");
        String authenticatorClassName = props.getProperty("authenticator_class", "");
        if (authenticator == null && !authenticatorClassName.isEmpty()) {
            authenticator = this.loadClass(authenticatorClassName, IAuthenticator.class, IConfig.class, props);
        }
        IResourceLoader resourceLoader = props.getResourceLoader();
        if (authenticator == null) {
            String passwdPath = props.getProperty("password_file", "");
            authenticator = passwdPath.isEmpty() ? new AcceptAllAuthenticator() : new ResourceAuthenticator(resourceLoader, passwdPath);
            LOG.info("An {} authenticator instance will be used", (Object)authenticator.getClass().getName());
        }
        LOG.info("Configuring MQTT authorizator...");
        String authorizatorClassName = props.getProperty("authorizator_class", "");
        if (authorizator == null && !authorizatorClassName.isEmpty()) {
            authorizator = this.loadClass(authorizatorClassName, IAuthorizator.class, IConfig.class, props);
        }
        if (authorizator == null) {
            String aclFilePath = props.getProperty("acl_file", "");
            if (aclFilePath != null && !aclFilePath.isEmpty()) {
                authorizator = new DenyAllAuthorizator();
                try {
                    LOG.info("Parsing ACL file. Path = {}", (Object)aclFilePath);
                    authorizator = ACLFileParser.parse(resourceLoader.loadResource(aclFilePath));
                }
                catch (ParseException pex) {
                    LOG.error("Unable to parse ACL file. path=" + aclFilePath, (Throwable)pex);
                }
            } else {
                authorizator = new PermitAllAuthorizator();
            }
            LOG.info("An {} authorizator instance will be used", (Object)authorizator.getClass().getName());
        }
        LOG.info("Initializing connection descriptor store...");
        this.connectionDescriptors = new ConnectionDescriptorStore(sessionsRepository);
        LOG.info("Initializing MQTT protocol processor...");
        boolean allowAnonymous = Boolean.parseBoolean(props.getProperty("allow_anonymous", "true"));
        boolean allowZeroByteClientId = Boolean.parseBoolean(props.getProperty("allow_zero_byte_client_id", "false"));
        this.m_processor.init(this.connectionDescriptors, subscriptions, messagesStore, this.m_sessionsStore, authenticator, allowAnonymous, allowZeroByteClientId, authorizator, interceptor, sessionsRepository);
        return this.m_processor;
    }

    private IStore instantiateConfiguredStore(String storageClassName, IConfig props, ScheduledExecutorService scheduledExecutor) {
        Constructor<IStore> constructor;
        Class<IStore> storageClass;
        LOG.info("Loading storage class {}", (Object)storageClassName);
        try {
            storageClass = this.getClass().getClassLoader().loadClass(storageClassName).asSubclass(IStore.class);
        }
        catch (ClassNotFoundException cnfex) {
            LOG.error("Cannot find storage class " + storageClassName + " in classpath", (Throwable)cnfex);
            return null;
        }
        try {
            constructor = storageClass.getConstructor(IConfig.class, ScheduledExecutorService.class);
        }
        catch (NoSuchMethodException nsmex) {
            LOG.error("Cannot find constructor with required params IConfig, ScheduledExecutorService ", (Throwable)nsmex);
            return null;
        }
        try {
            return constructor.newInstance(props, scheduledExecutor);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            LOG.error("Cannot instantiate the " + storageClassName + " instance", (Throwable)ex);
            return null;
        }
    }

    private <T, U> T loadClass(String className, Class<T> intrface, Class<U> constructorArgClass, U props) {
        T instance = null;
        try {
            LOG.info("Invoking constructor with {} argument. ClassName={}, interfaceName={}", new Object[]{constructorArgClass.getName(), className, intrface.getName()});
            instance = this.getClass().getClassLoader().loadClass(className).asSubclass(intrface).getConstructor(constructorArgClass).newInstance(props);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.warn("Unable to invoke constructor with {} argument. ClassName={}, interfaceName={}, cause={}, errorMessage={}", new Object[]{constructorArgClass.getName(), className, intrface.getName(), ex.getCause(), ex.getMessage()});
            return null;
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            try {
                LOG.info("Invoking default constructor. ClassName={}, interfaceName={}", (Object)className, (Object)intrface.getName());
                instance = this.getClass().getClassLoader().loadClass(className).asSubclass(intrface).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                LOG.error("Unable to invoke default constructor. ClassName={}, interfaceName={}, cause={}, errorMessage={}", new Object[]{className, intrface.getName(), ex.getCause(), ex.getMessage()});
                return null;
            }
        }
        return instance;
    }

    public ISessionsStore getSessionsStore() {
        return this.m_sessionsStore;
    }

    public List<Subscription> getSubscriptions() {
        return this.subscriptionsStore.listAllSubscriptions();
    }

    public void shutdown() {
        if (this.storeShutdown != null) {
            this.storeShutdown.run();
        }
        if (this.m_processor != null) {
            this.m_processor.shutdown();
        }
    }

    public ConnectionDescriptorStore getConnectionDescriptors() {
        return this.connectionDescriptors;
    }
}

