/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty.metrics;

import io.moquette.server.netty.NettyUtils;
import io.moquette.spi.impl.Utils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MQTTMessageLogger
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)"messageLogger");

    public void channelRead(ChannelHandlerContext ctx, Object message) {
        this.logMQTTMessage(ctx, message, "C->B");
        ctx.fireChannelRead(message);
    }

    private void logMQTTMessage(ChannelHandlerContext ctx, Object message, String direction) {
        if (!(message instanceof MqttMessage)) {
            return;
        }
        MqttMessage msg = (MqttMessage)message;
        String clientID = NettyUtils.clientID(ctx.channel());
        MqttMessageType messageType = msg.fixedHeader().messageType();
        switch (messageType) {
            case CONNECT: 
            case CONNACK: 
            case PINGREQ: 
            case PINGRESP: 
            case DISCONNECT: {
                LOG.info("{} {} <{}>", new Object[]{direction, messageType, clientID});
                break;
            }
            case SUBSCRIBE: {
                MqttSubscribeMessage subscribe = (MqttSubscribeMessage)msg;
                LOG.info("{} SUBSCRIBE <{}> to topics {}", new Object[]{direction, clientID, subscribe.payload().topicSubscriptions()});
                break;
            }
            case UNSUBSCRIBE: {
                MqttUnsubscribeMessage unsubscribe = (MqttUnsubscribeMessage)msg;
                LOG.info("{} UNSUBSCRIBE <{}> to topics <{}>", new Object[]{direction, clientID, unsubscribe.payload().topics()});
                break;
            }
            case PUBLISH: {
                MqttPublishMessage publish = (MqttPublishMessage)msg;
                LOG.info("{} PUBLISH <{}> to topics <{}>", new Object[]{direction, clientID, publish.variableHeader().topicName()});
                break;
            }
            case PUBREC: 
            case PUBCOMP: 
            case PUBREL: 
            case PUBACK: 
            case UNSUBACK: {
                LOG.info("{} {} <{}> packetID <{}>", new Object[]{direction, messageType, clientID, Utils.messageId(msg)});
                break;
            }
            case SUBACK: {
                MqttSubAckMessage suback = (MqttSubAckMessage)msg;
                List grantedQoSLevels = suback.payload().grantedQoSLevels();
                LOG.info("{} SUBACK <{}> packetID <{}>, grantedQoses {}", new Object[]{direction, clientID, Utils.messageId(msg), grantedQoSLevels});
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientID = NettyUtils.clientID(ctx.channel());
        if (clientID != null && !clientID.isEmpty()) {
            LOG.info("Channel closed <{}>", (Object)clientID);
        }
        ctx.fireChannelInactive();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.logMQTTMessage(ctx, msg, "C<-B");
        ctx.write(msg, promise);
    }
}

