/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty;

import io.moquette.server.netty.NettyUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class MoquetteIdleTimeoutHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MoquetteIdleTimeoutHandler.class);

    MoquetteIdleTimeoutHandler() {
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState e = ((IdleStateEvent)evt).state();
            if (e == IdleState.READER_IDLE) {
                LOG.info("Firing channel inactive event. MqttClientId = {}.", (Object)NettyUtils.clientID(ctx.channel()));
                ctx.fireChannelInactive();
                ctx.close();
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Firing Netty event. MqttClientId = {}, eventClass = {}.", (Object)NettyUtils.clientID(ctx.channel()), (Object)evt.getClass().getName());
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

