/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server;

import io.moquette.server.netty.AutoFlushHandler;
import io.moquette.server.netty.NettyUtils;
import io.moquette.server.netty.metrics.BytesMetrics;
import io.moquette.server.netty.metrics.BytesMetricsHandler;
import io.moquette.server.netty.metrics.MessageMetrics;
import io.moquette.server.netty.metrics.MessageMetricsHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionDescriptor.class);
    public final String clientID;
    private final Channel channel;
    public final boolean cleanSession;
    private final AtomicReference<ConnectionState> channelState = new AtomicReference<ConnectionState>(ConnectionState.DISCONNECTED);

    public ConnectionDescriptor(String clientID, Channel session, boolean cleanSession) {
        this.clientID = clientID;
        this.channel = session;
        this.cleanSession = cleanSession;
    }

    public void writeAndFlush(Object payload) {
        this.channel.writeAndFlush(payload);
    }

    public void setupAutoFlusher(int flushIntervalMs) {
        try {
            this.channel.pipeline().addAfter("idleEventHandler", "autoFlusher", (ChannelHandler)new AutoFlushHandler(flushIntervalMs, TimeUnit.MILLISECONDS));
        }
        catch (NoSuchElementException nseex) {
            this.channel.pipeline().addFirst("autoFlusher", (ChannelHandler)new AutoFlushHandler(flushIntervalMs, TimeUnit.MILLISECONDS));
        }
    }

    public boolean doesNotUseChannel(Channel channel) {
        return !this.channel.equals(channel);
    }

    public boolean close() {
        LOG.info("Closing connection descriptor. MqttClientId = {}.", (Object)this.clientID);
        boolean success = this.assignState(ConnectionState.INTERCEPTORS_NOTIFIED, ConnectionState.DISCONNECTED);
        if (!success) {
            return false;
        }
        this.channel.close();
        return true;
    }

    public String getUsername() {
        return NettyUtils.userName(this.channel);
    }

    public void abort() {
        LOG.info("Closing connection descriptor. MqttClientId = {}.", (Object)this.clientID);
        this.channel.close();
    }

    public boolean assignState(ConnectionState expected, ConnectionState newState) {
        LOG.debug("Updating state of connection descriptor. MqttClientId = {}, expectedState = {}, newState = {}.", new Object[]{this.clientID, expected, newState});
        boolean retval = this.channelState.compareAndSet(expected, newState);
        if (!retval) {
            LOG.error("Unable to update state of connection descriptor. MqttclientId = {}, expectedState = {}, newState = {}.", new Object[]{this.clientID, expected, newState});
        }
        return retval;
    }

    public String toString() {
        return "ConnectionDescriptor{clientID=" + this.clientID + ", removeTemporaryQoS2=" + this.cleanSession + ", state=" + (Object)((Object)this.channelState.get()) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionDescriptor that = (ConnectionDescriptor)o;
        if (this.clientID != null ? !this.clientID.equals(that.clientID) : that.clientID != null) {
            return false;
        }
        return !(this.channel == null ? that.channel != null : !this.channel.equals(that.channel));
    }

    public BytesMetrics getBytesMetrics() {
        return BytesMetricsHandler.getBytesMetrics(this.channel);
    }

    public MessageMetrics getMessageMetrics() {
        return MessageMetricsHandler.getMessageMetrics(this.channel);
    }

    public int hashCode() {
        int result = this.clientID != null ? this.clientID.hashCode() : 0;
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        return result;
    }

    public static enum ConnectionState {
        DISCONNECTED,
        SENDACK,
        SESSION_CREATED,
        MESSAGES_REPUBLISHED,
        ESTABLISHED,
        SUBSCRIPTIONS_REMOVED,
        MESSAGES_DROPPED,
        INTERCEPTORS_NOTIFIED;

    }
}

