/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.persistence.PersistentSession;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.ISubscriptionsStore;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.Topic;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemorySessionStore
implements ISessionsStore,
ISubscriptionsStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemorySessionStore.class);
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private ConcurrentNavigableMap<LocalDateTime, Set<String>> sessionsClosingTimes = new ConcurrentSkipListMap<LocalDateTime, Set<String>>();

    MemorySessionStore() {
    }

    private Session getSession(String clientID) {
        Session session = this.sessions.get(clientID);
        if (session == null) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            throw new RuntimeException("Can't find the session for client <" + clientID + ">");
        }
        return session;
    }

    @Override
    public void removeSubscription(Topic topic, String clientID) {
        LOG.debug("removeSubscription topic filter: {} for clientID: {}", (Object)topic, (Object)clientID);
        this.getSession((String)clientID).subscriptions.remove(topic);
    }

    @Override
    public void initStore() {
    }

    @Override
    public ISubscriptionsStore subscriptionStore() {
        return this;
    }

    @Override
    public void addNewSubscription(Subscription newSubscription) {
        String clientID = newSubscription.getClientId();
        Session session = this.sessions.get(clientID);
        if (session == null) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return;
        }
        session.subscriptions.put(newSubscription.getTopicFilter(), newSubscription);
    }

    @Override
    public void wipeSubscriptions(String clientID) {
        if (!this.sessions.containsKey(clientID)) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return;
        }
        this.sessions.get((Object)clientID).subscriptions.clear();
    }

    @Override
    public boolean contains(String clientID) {
        return this.sessions.containsKey(clientID);
    }

    @Override
    public void createNewDurableSession(String clientID) {
        Session innerSession = new Session(clientID, false);
        this.sessions.put(clientID, innerSession);
    }

    @Override
    public void removeDurableSession(String clientId) {
        this.sessions.remove(clientId);
        this.wipeSubscriptions(clientId);
    }

    @Override
    public void updateCleanStatus(String clientId, boolean newCleanStatus) {
        this.sessions.get((Object)clientId).cleanSession = newCleanStatus;
    }

    @Override
    public PersistentSession loadSessionByKey(String clientID) {
        return new PersistentSession(clientID, this.sessions.get((Object)clientID).cleanSession);
    }

    @Override
    public Collection<PersistentSession> listAllSessions() {
        ArrayList<PersistentSession> result = new ArrayList<PersistentSession>();
        for (Session entry : this.sessions.values()) {
            result.add(new PersistentSession(entry.clientID, entry.cleanSession));
        }
        return result;
    }

    @Override
    public List<Subscription> listAllSubscriptions() {
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        for (Session entry : this.sessions.values()) {
            allSubscriptions.addAll(entry.subscriptions.values());
        }
        return allSubscriptions;
    }

    @Override
    public Collection<Subscription> listClientSubscriptions(String clientID) {
        Session session = this.sessions.get(clientID);
        if (session == null) {
            throw new IllegalStateException("Asking for subscriptions of not persisted client: " + clientID);
        }
        return session.subscriptions.values();
    }

    @Override
    public Subscription reload(Subscription subcription) {
        String clientID = subcription.getClientId();
        if (!this.sessions.containsKey(clientID)) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return null;
        }
        Map<Topic, Subscription> subscriptions = this.sessions.get((Object)clientID).subscriptions;
        if (subscriptions == null || subscriptions.isEmpty()) {
            return null;
        }
        return subscriptions.get(subcription.getTopicFilter());
    }

    @Override
    public IMessagesStore.StoredMessage inFlightAck(String clientID, int messageID) {
        return this.getSession((String)clientID).outboundFlightMessages.remove(messageID);
    }

    @Override
    public void inFlight(String clientID, int messageID, IMessagesStore.StoredMessage msg) {
        Session session = this.sessions.get(clientID);
        if (session == null) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return;
        }
        session.outboundFlightMessages.put(messageID, msg);
    }

    @Override
    public int nextPacketID(String clientID) {
        if (!this.sessions.containsKey(clientID)) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return -1;
        }
        Map<Integer, IMessagesStore.StoredMessage> m = this.sessions.get((Object)clientID).outboundFlightMessages;
        int maxId = m.keySet().isEmpty() ? 0 : Collections.max(m.keySet());
        int nextPacketId = (maxId + 1) % 65535;
        m.put(nextPacketId, null);
        return nextPacketId;
    }

    public BlockingQueue<IMessagesStore.StoredMessage> queue(String clientID) {
        if (!this.sessions.containsKey(clientID)) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return null;
        }
        return this.sessions.get((Object)clientID).queue;
    }

    @Override
    public void dropQueue(String clientID) {
        Session session = this.sessions.get(clientID);
        session.queue.clear();
        session.outboundFlightMessages.clear();
        session.inboundFlightMessages.clear();
    }

    @Override
    public void moveInFlightToSecondPhaseAckWaiting(String clientID, int messageID, IMessagesStore.StoredMessage msg) {
        LOG.info("Moving msg inflight second phase store, clientID <{}> messageID {}", (Object)clientID, (Object)messageID);
        Session session = this.sessions.get(clientID);
        if (session == null) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return;
        }
        session.secondPhaseStore.put(messageID, msg);
        session.outboundFlightMessages.put(messageID, msg);
    }

    @Override
    public IMessagesStore.StoredMessage completeReleasedPublish(String clientID, int messageID) {
        LOG.info("Acknowledged message in second phase, clientID <{}> messageID {}", (Object)clientID, (Object)messageID);
        return this.getSession((String)clientID).secondPhaseStore.remove(messageID);
    }

    @Override
    public int getInflightMessagesNo(String clientID) {
        Session session = this.sessions.get(clientID);
        if (session == null) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return 0;
        }
        return session.inboundFlightMessages.size() + session.outboundFlightMessages.size();
    }

    @Override
    public int countPubReleaseWaitingPubComplete(String clientID) {
        if (!this.sessions.containsKey(clientID)) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return 0;
        }
        return this.sessions.get((Object)clientID).secondPhaseStore.size();
    }

    @Override
    public void removeTemporaryQoS2(String clientID) {
        LOG.debug("Session cleanup for client <{}>", (Object)clientID);
        Session session = this.sessions.get(clientID);
        if (session == null) {
            LOG.error("Can't find the session for client <{}>", (Object)clientID);
            return;
        }
        LOG.info("Removing stored messages with QoS 2. ClientId={}", (Object)clientID);
        session.secondPhaseStore.clear();
    }

    @Override
    public synchronized void trackSessionClose(LocalDateTime when, String clientID) {
        this.sessionsClosingTimes.putIfAbsent(when, new HashSet());
        this.sessionsClosingTimes.computeIfPresent(when, (key, oldSet) -> {
            oldSet.add(clientID);
            return oldSet;
        });
    }

    @Override
    public Set<String> sessionOlderThan(LocalDateTime queryPin) {
        HashSet<String> results = new HashSet<String>();
        LocalDateTime keyBefore = this.sessionsClosingTimes.lowerKey(queryPin);
        while (keyBefore != null) {
            results.addAll((Collection)this.sessionsClosingTimes.get(keyBefore));
            keyBefore = this.sessionsClosingTimes.lowerKey(keyBefore);
        }
        return results;
    }

    class Session {
        final String clientID;
        final Map<Topic, Subscription> subscriptions = new ConcurrentHashMap<Topic, Subscription>();
        boolean cleanSession;
        final BlockingQueue<IMessagesStore.StoredMessage> queue = new ArrayBlockingQueue<IMessagesStore.StoredMessage>(1024);
        final Map<Integer, IMessagesStore.StoredMessage> secondPhaseStore = new ConcurrentHashMap<Integer, IMessagesStore.StoredMessage>();
        final Map<Integer, IMessagesStore.StoredMessage> outboundFlightMessages = Collections.synchronizedMap(new HashMap());
        final Map<Integer, IMessagesStore.StoredMessage> inboundFlightMessages = new ConcurrentHashMap<Integer, IMessagesStore.StoredMessage>();

        Session(String clientID, boolean cleanSession) {
            this.clientID = clientID;
            this.cleanSession = cleanSession;
        }
    }
}

