/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.interception;

import io.moquette.interception.messages.InterceptPublishMessage;
import io.moquette.spi.impl.Utils;
import java.io.Serializable;

public class HazelcastMsg
implements Serializable {
    private static final long serialVersionUID = -1431584750134928273L;
    private final String clientId;
    private final int qos;
    private final byte[] payload;
    private final String topic;

    public HazelcastMsg(InterceptPublishMessage msg) {
        this.clientId = msg.getClientID();
        this.topic = msg.getTopicName();
        this.qos = msg.getQos().value();
        this.payload = Utils.readBytesAndRewind(msg.getPayload());
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getQos() {
        return this.qos;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getTopic() {
        return this.topic;
    }
}

