/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.subscriptions;

import io.moquette.spi.impl.subscriptions.INode;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.Token;
import io.moquette.spi.impl.subscriptions.Topic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CNode {
    Token token;
    private List<INode> children;
    Set<Subscription> subscriptions;

    CNode() {
        this.children = new ArrayList<INode>();
        this.subscriptions = new HashSet<Subscription>();
    }

    private CNode(Token token, List<INode> children, Set<Subscription> subscriptions) {
        this.token = token;
        this.subscriptions = new HashSet<Subscription>(subscriptions);
        this.children = new ArrayList<INode>(children);
    }

    boolean anyChildrenMatch(Token token) {
        for (INode iNode : this.children) {
            CNode child = iNode.mainNode();
            if (!child.equals(token)) continue;
            return true;
        }
        return false;
    }

    List<INode> allChildren() {
        return this.children;
    }

    INode childOf(Token token) {
        for (INode iNode : this.children) {
            CNode child = iNode.mainNode();
            if (!child.equals(token)) continue;
            return iNode;
        }
        throw new IllegalArgumentException("Asked for a token that doesn't exists in any child [" + token + "]");
    }

    private boolean equals(Token token) {
        return this.token != null && this.token.equals(token);
    }

    CNode copy() {
        return new CNode(this.token, this.children, this.subscriptions);
    }

    public void add(INode newINode) {
        this.children.add(newINode);
    }

    public void remove(INode node) {
        this.children.remove(node);
    }

    CNode addSubscription(String clientId, Topic topic) {
        this.subscriptions.add(new Subscription(clientId, topic));
        return this;
    }

    boolean containsOnly(String clientId) {
        for (Subscription sub : this.subscriptions) {
            if (sub.clientId.equals(clientId)) continue;
            return false;
        }
        return !this.subscriptions.isEmpty();
    }

    public boolean contains(String clientId) {
        for (Subscription sub : this.subscriptions) {
            if (!sub.clientId.equals(clientId)) continue;
            return true;
        }
        return false;
    }

    void removeSubscriptionsFor(String clientId) {
        HashSet<Subscription> toRemove = new HashSet<Subscription>();
        for (Subscription sub : this.subscriptions) {
            if (!sub.clientId.equals(clientId)) continue;
            toRemove.add(sub);
        }
        this.subscriptions.removeAll(toRemove);
    }
}

