/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.security;

import io.moquette.spi.impl.security.AuthorizationsCollector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ACLFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(ACLFileParser.class);

    public static AuthorizationsCollector parse(File file) throws ParseException {
        if (file == null) {
            LOG.warn("parsing NULL file, so fallback on default configuration!");
            return AuthorizationsCollector.emptyImmutableCollector();
        }
        if (!file.exists()) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()));
            return AuthorizationsCollector.emptyImmutableCollector();
        }
        try {
            FileReader reader = new FileReader(file);
            return ACLFileParser.parse(reader);
        }
        catch (FileNotFoundException fex) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()), (Throwable)fex);
            return AuthorizationsCollector.emptyImmutableCollector();
        }
    }

    public static AuthorizationsCollector parse(Reader reader) throws ParseException {
        if (reader == null) {
            LOG.warn("parsing NULL reader, so fallback on default configuration!");
            return AuthorizationsCollector.emptyImmutableCollector();
        }
        BufferedReader br = new BufferedReader(reader);
        AuthorizationsCollector collector = new AuthorizationsCollector();
        Pattern emptyLine = Pattern.compile("^\\s*$");
        Pattern commentLine = Pattern.compile("^#.*");
        Pattern invalidCommentLine = Pattern.compile("^\\s*#.*");
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || emptyLine.matcher(line).matches() || commentLine.matcher(line).matches()) continue;
                if (invalidCommentLine.matcher(line).matches()) {
                    int commentMarker = line.indexOf(35);
                    throw new ParseException(line, commentMarker);
                }
                collector.parse(line);
            }
        }
        catch (IOException ex) {
            throw new ParseException("Failed to read", 1);
        }
        return collector;
    }

    private ACLFileParser() {
    }
}

