/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.server.ConnectionDescriptorStore;
import io.moquette.spi.ClientSession;
import io.moquette.spi.impl.DebugUtils;
import io.moquette.spi.impl.ProtocolProcessor;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistentQueueMessageSender {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentQueueMessageSender.class);
    private final ConnectionDescriptorStore connectionDescriptorStore;

    PersistentQueueMessageSender(ConnectionDescriptorStore connectionDescriptorStore) {
        this.connectionDescriptorStore = connectionDescriptorStore;
    }

    void sendPublish(ClientSession clientsession, MqttPublishMessage pubMessage) {
        String clientId = clientsession.clientID;
        int messageId = pubMessage.variableHeader().messageId();
        String topicName = pubMessage.variableHeader().topicName();
        MqttQoS qos = pubMessage.fixedHeader().qosLevel();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending PUBLISH message. MessageId={}, CId={}, topic={}, qos={}, payload={}", new Object[]{messageId, clientId, topicName, qos, DebugUtils.payload2Str(pubMessage.payload())});
        } else {
            LOG.info("Sending PUBLISH message. MessageId={}, CId={}, topic={}", new Object[]{messageId, clientId, topicName});
        }
        boolean messageDelivered = this.connectionDescriptorStore.sendMessage((MqttMessage)pubMessage, messageId, clientId);
        if (!messageDelivered) {
            if (qos != MqttQoS.AT_MOST_ONCE && !clientsession.isCleanSession()) {
                LOG.warn("PUBLISH message could not be delivered. It will be stored. MessageId={}, CId={}, topic={}, qos={}, removeTemporaryQoS2={}", new Object[]{messageId, clientId, topicName, qos, false});
                clientsession.enqueue(ProtocolProcessor.asStoredMessage(pubMessage));
            } else {
                LOG.warn("PUBLISH message could not be delivered. It will be discarded. MessageId={}, CId={}, topic={}, qos={}, removeTemporaryQoS2={}", new Object[]{messageId, clientId, topicName, qos, true});
            }
        }
    }
}

