/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.spi.ClientSession;
import io.moquette.spi.EnqueuedMessage;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.impl.PersistentQueueMessageSender;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalRepublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InternalRepublisher.class);
    private final PersistentQueueMessageSender messageSender;

    InternalRepublisher(PersistentQueueMessageSender messageSender) {
        this.messageSender = messageSender;
    }

    void publishRetained(ClientSession targetSession, Collection<IMessagesStore.StoredMessage> messages) {
        for (IMessagesStore.StoredMessage storedMsg : messages) {
            MqttPublishMessage publishMsg = this.retainedPublish(storedMsg);
            if (storedMsg.getQos() != MqttQoS.AT_MOST_ONCE) {
                LOG.debug("Adding message to inflight zone. ClientId={}, topic={}", (Object)targetSession.clientID, (Object)storedMsg.getTopic());
                int packetID = targetSession.inFlightAckWaiting(storedMsg);
                publishMsg = this.retainedPublish(storedMsg, packetID);
            }
            this.messageSender.sendPublish(targetSession, publishMsg);
        }
    }

    void publishStored(ClientSession clientSession) {
        EnqueuedMessage pubEvt;
        if (clientSession.isEmptyQueue()) {
            LOG.info("There are no stored publish events to CId={}", (Object)clientSession.clientID);
            return;
        }
        while ((pubEvt = clientSession.poll()) != null) {
            LOG.debug("Adding message ot inflight zone. ClientId={}, guid={}, topic={}", new Object[]{clientSession.clientID, pubEvt.msg.getGuid(), pubEvt.msg.getTopic()});
            MqttPublishMessage publishMsg = this.notRetainedPublish(pubEvt.msg);
            if (publishMsg.fixedHeader().qosLevel() != MqttQoS.AT_MOST_ONCE) {
                publishMsg = this.notRetainedPublish(pubEvt.msg, pubEvt.messageId);
            }
            this.messageSender.sendPublish(clientSession, publishMsg);
        }
    }

    private MqttPublishMessage notRetainedPublish(IMessagesStore.StoredMessage storedMessage, Integer messageID) {
        return InternalRepublisher.createPublishForQos(storedMessage.getTopic(), storedMessage.getQos(), storedMessage.getPayload(), false, messageID);
    }

    private MqttPublishMessage notRetainedPublish(IMessagesStore.StoredMessage storedMessage) {
        return InternalRepublisher.createPublishForQos(storedMessage.getTopic(), storedMessage.getQos(), storedMessage.getPayload(), false, 0);
    }

    private MqttPublishMessage retainedPublish(IMessagesStore.StoredMessage storedMessage) {
        return InternalRepublisher.createPublishForQos(storedMessage.getTopic(), storedMessage.getQos(), storedMessage.getPayload(), true, 0);
    }

    private MqttPublishMessage retainedPublish(IMessagesStore.StoredMessage storedMessage, Integer packetID) {
        return InternalRepublisher.createPublishForQos(storedMessage.getTopic(), storedMessage.getQos(), storedMessage.getPayload(), true, packetID);
    }

    public static MqttPublishMessage createPublishForQos(String topic, MqttQoS qos, ByteBuf message, boolean retained, int messageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, qos, retained, 0);
        MqttPublishVariableHeader varHeader = new MqttPublishVariableHeader(topic, messageId);
        return new MqttPublishMessage(fixedHeader, varHeader, message);
    }
}

