/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi;

import io.moquette.spi.ClientSession;
import io.moquette.spi.EnqueuedMessage;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.Topic;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientSession
extends ClientSession {
    private static final Logger LOG = LoggerFactory.getLogger(TransientSession.class);
    private Queue<IMessagesStore.StoredMessage> messagesQueue = new LinkedList<IMessagesStore.StoredMessage>();
    private final AtomicInteger packetGenerator = new AtomicInteger(1);
    private final ConcurrentMap<Integer, IMessagesStore.StoredMessage> inboundInflightMap = new ConcurrentHashMap<Integer, IMessagesStore.StoredMessage>();
    private final ConcurrentMap<Integer, IMessagesStore.StoredMessage> outboundInflightMap = new ConcurrentHashMap<Integer, IMessagesStore.StoredMessage>();
    private final Map<Integer, IMessagesStore.StoredMessage> secondPhaseStore = new ConcurrentHashMap<Integer, IMessagesStore.StoredMessage>();

    public TransientSession(String clientID) {
        super(clientID);
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isCleanSession() {
        return true;
    }

    @Override
    public boolean subscribe(Subscription newSubscription) {
        Subscription existingSub;
        LOG.info("Adding new subscription. CId={}, topics={}, qos={}", new Object[]{newSubscription.getClientId(), newSubscription.getTopicFilter(), newSubscription.getRequestedQos()});
        boolean validTopic = newSubscription.getTopicFilter().isValid();
        if (!validTopic) {
            LOG.warn("The topic filter is not valid. CId={}, topics={}", (Object)newSubscription.getClientId(), (Object)newSubscription.getTopicFilter());
            return false;
        }
        Optional<Subscription> mathingExisting = this.subscriptions.stream().filter(s -> s.equals(newSubscription)).findFirst();
        if (mathingExisting.isPresent() && (existingSub = mathingExisting.get()).qosLessThan(newSubscription)) {
            LOG.info("Subscription already existed with a lower QoS value. It will be updated. CId={}, topics={}, existingQos={}, newQos={}", new Object[]{newSubscription.getClientId(), newSubscription.getTopicFilter(), existingSub.getRequestedQos(), newSubscription.getRequestedQos()});
            this.subscriptions.remove(newSubscription);
        }
        this.subscriptions.add(newSubscription);
        return true;
    }

    @Override
    public void unsubscribeFrom(Topic topicFilter) {
        LOG.info("Removing subscription. CId={}, topics={}", (Object)this.clientID, (Object)topicFilter);
        HashSet<Subscription> subscriptionsToRemove = new HashSet<Subscription>();
        for (Subscription sub : this.subscriptions) {
            if (!sub.getTopicFilter().equals(topicFilter)) continue;
            subscriptionsToRemove.add(sub);
        }
        this.subscriptions.removeAll(subscriptionsToRemove);
    }

    @Override
    public boolean isEmptyQueue() {
        return this.messagesQueue.isEmpty();
    }

    @Override
    public void enqueue(IMessagesStore.StoredMessage message) {
        this.messagesQueue.offer(message);
    }

    @Override
    public EnqueuedMessage poll() {
        IMessagesStore.StoredMessage msg = this.messagesQueue.poll();
        if (msg == null) {
            return null;
        }
        int messageId = this.inFlightAckWaiting(msg);
        return new EnqueuedMessage(msg, messageId);
    }

    @Override
    public void dropQueue() {
        LOG.debug("Removing messages of session. CId={}", (Object)this.clientID);
        this.messagesQueue = null;
        LOG.debug("Messages of the session have been removed. CId={}", (Object)this.clientID);
    }

    @Override
    public void cleanSession() {
        LOG.info("Transient sessiom, wiping existing subscriptions. ClientId={}", (Object)this.clientID);
        this.subscriptions.clear();
    }

    @Override
    protected int nextPacketId() {
        return this.packetGenerator.getAndIncrement();
    }

    @Override
    public int inFlightAckWaiting(IMessagesStore.StoredMessage msg) {
        LOG.debug("Adding message to inflight zone. CId={}", (Object)this.clientID);
        int messageId = this.nextPacketId();
        this.outboundInflightMap.put(messageId, msg);
        return messageId;
    }

    @Override
    public IMessagesStore.StoredMessage inFlightAcknowledged(int messageID) {
        LOG.debug("Removing message to inflight zone. CId={}, messageID={}", (Object)this.clientID, (Object)messageID);
        return (IMessagesStore.StoredMessage)this.outboundInflightMap.remove(messageID);
    }

    @Override
    public void markAsInboundInflight(int messageID, IMessagesStore.StoredMessage msg) {
        this.inboundInflightMap.put(messageID, msg);
    }

    @Override
    public IMessagesStore.StoredMessage inboundInflight(int messageID) {
        return (IMessagesStore.StoredMessage)this.inboundInflightMap.remove(messageID);
    }

    @Override
    public void moveInFlightToSecondPhaseAckWaiting(int messageID, IMessagesStore.StoredMessage msg) {
        this.secondPhaseStore.put(messageID, msg);
        this.outboundInflightMap.put(messageID, msg);
    }

    @Override
    public IMessagesStore.StoredMessage completeReleasedPublish(int messageID) {
        LOG.info("Acknowledged message in second phase, clientID <{}> messageID {}", (Object)this.clientID, (Object)messageID);
        return this.secondPhaseStore.remove(messageID);
    }

    @Override
    public int getPendingPublishMessagesNo() {
        return this.messagesQueue.size();
    }

    @Override
    public int countPubReleaseWaitingPubComplete() {
        return this.outboundInflightMap.size();
    }

    @Override
    public int getInflightMessagesNo() {
        return this.inboundInflightMap.size();
    }
}

