/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi;

import io.moquette.spi.IMatchingCondition;
import io.moquette.spi.MessageGUID;
import io.moquette.spi.impl.subscriptions.Topic;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import java.util.Collection;

public interface IMessagesStore {
    public void initStore();

    public Collection<StoredMessage> searchMatching(IMatchingCondition var1);

    public void cleanRetained(Topic var1);

    public void storeRetained(Topic var1, StoredMessage var2);

    public static class StoredMessage
    implements Serializable {
        private static final long serialVersionUID = 1755296138639817304L;
        final MqttQoS m_qos;
        final byte[] m_payload;
        final String m_topic;
        private boolean m_retained;
        private String m_clientID;
        private MessageGUID m_guid;

        public StoredMessage(byte[] message, MqttQoS qos, String topic) {
            this.m_qos = qos;
            this.m_payload = message;
            this.m_topic = topic;
        }

        public MqttQoS getQos() {
            return this.m_qos;
        }

        public String getTopic() {
            return this.m_topic;
        }

        public void setGuid(MessageGUID guid) {
            this.m_guid = guid;
        }

        public MessageGUID getGuid() {
            return this.m_guid;
        }

        public String getClientID() {
            return this.m_clientID;
        }

        public void setClientID(String m_clientID) {
            this.m_clientID = m_clientID;
        }

        public ByteBuf getPayload() {
            return Unpooled.copiedBuffer((byte[])this.m_payload);
        }

        public void setRetained(boolean retained) {
            this.m_retained = retained;
        }

        public boolean isRetained() {
            return this.m_retained;
        }

        public String toString() {
            return "PublishEvent{clientID='" + this.m_clientID + '\'' + ", m_retain=" + this.m_retained + ", m_qos=" + this.m_qos + ", m_topic='" + this.m_topic + '\'' + '}';
        }
    }
}

