/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi;

import io.moquette.spi.EnqueuedMessage;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.Topic;
import java.util.HashSet;
import java.util.Set;

public abstract class ClientSession {
    public final String clientID;
    protected Set<Subscription> subscriptions = new HashSet<Subscription>();

    public ClientSession(String clientID) {
        this.clientID = clientID;
    }

    public Subscription findSubscriptionByTopicFilter(Subscription matchingSub) {
        for (Subscription sub : this.subscriptions) {
            if (!matchingSub.equals(sub)) continue;
            return sub;
        }
        return null;
    }

    public Set<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public abstract boolean isCleanSession();

    public abstract boolean subscribe(Subscription var1);

    public abstract void unsubscribeFrom(Topic var1);

    public abstract void disconnect();

    public abstract void cleanSession();

    protected abstract int nextPacketId();

    public abstract IMessagesStore.StoredMessage inFlightAcknowledged(int var1);

    public abstract int inFlightAckWaiting(IMessagesStore.StoredMessage var1);

    public abstract IMessagesStore.StoredMessage completeReleasedPublish(int var1);

    public abstract void enqueue(IMessagesStore.StoredMessage var1);

    public abstract EnqueuedMessage poll();

    public abstract boolean isEmptyQueue();

    public abstract void dropQueue();

    public abstract IMessagesStore.StoredMessage inboundInflight(int var1);

    public abstract void markAsInboundInflight(int var1, IMessagesStore.StoredMessage var2);

    public abstract void moveInFlightToSecondPhaseAckWaiting(int var1, IMessagesStore.StoredMessage var2);

    public abstract int getPendingPublishMessagesNo();

    public abstract int countPubReleaseWaitingPubComplete();

    public abstract int getInflightMessagesNo();

    public String toString() {
        return this.getClass().getSimpleName() + "{clientID='" + this.clientID + "'}";
    }
}

