/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty;

import io.moquette.server.netty.NettyUtils;
import io.moquette.spi.impl.ProtocolProcessor;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyMQTTHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NettyMQTTHandler.class);
    private final ProtocolProcessor m_processor;

    public NettyMQTTHandler(ProtocolProcessor processor) {
        this.m_processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        MqttMessage msg = (MqttMessage)message;
        MqttMessageType messageType = msg.fixedHeader().messageType();
        LOG.debug("Processing MQTT message, type={}", (Object)messageType);
        try {
            switch (messageType) {
                case CONNECT: {
                    this.m_processor.processConnect(ctx.channel(), (MqttConnectMessage)msg);
                    return;
                }
                case SUBSCRIBE: {
                    this.m_processor.processSubscribe(ctx.channel(), (MqttSubscribeMessage)msg);
                    return;
                }
                case UNSUBSCRIBE: {
                    this.m_processor.processUnsubscribe(ctx.channel(), (MqttUnsubscribeMessage)msg);
                    return;
                }
                case PUBLISH: {
                    this.m_processor.processPublish(ctx.channel(), (MqttPublishMessage)msg);
                    return;
                }
                case PUBREC: {
                    this.m_processor.processPubRec(ctx.channel(), msg);
                    return;
                }
                case PUBCOMP: {
                    this.m_processor.processPubComp(ctx.channel(), msg);
                    return;
                }
                case PUBREL: {
                    this.m_processor.processPubRel(ctx.channel(), msg);
                    return;
                }
                case DISCONNECT: {
                    this.m_processor.processDisconnect(ctx.channel());
                    return;
                }
                case PUBACK: {
                    this.m_processor.processPubAck(ctx.channel(), (MqttPubAckMessage)msg);
                    return;
                }
                case PINGREQ: {
                    MqttFixedHeader pingHeader = new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0);
                    MqttMessage pingResp = new MqttMessage(pingHeader);
                    ctx.writeAndFlush((Object)pingResp);
                    return;
                }
                default: {
                    LOG.error("Unkonwn MessageType:{}", (Object)messageType);
                    return;
                }
            }
        }
        catch (Throwable ex) {
            LOG.error("Exception was caught while processing MQTT message, " + ex.getCause(), ex);
            ctx.fireExceptionCaught(ex);
            ctx.close();
            return;
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientID = NettyUtils.clientID(ctx.channel());
        if (clientID != null && !clientID.isEmpty()) {
            LOG.info("Notifying connection lost event. MqttClientId = {}.", (Object)clientID);
            this.m_processor.processConnectionLost(clientID, ctx.channel());
        }
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("An unexpected exception was caught while processing MQTT message. Closing Netty channel. CId={}, cause={}, errorMessage={}", new Object[]{NettyUtils.clientID(ctx.channel()), cause.getCause(), cause.getMessage()});
        ctx.close();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            this.m_processor.notifyChannelWritable(ctx.channel());
        }
        ctx.fireChannelWritabilityChanged();
    }
}

