/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server;

import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import io.moquette.interception.HazelcastMsg;
import io.moquette.server.Server;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastListener
implements MessageListener<HazelcastMsg> {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastListener.class);
    private final Server server;

    public HazelcastListener(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message<HazelcastMsg> msg) {
        ByteBuf payload = null;
        try {
            if (!msg.getPublishingMember().equals(this.server.getHazelcastInstance().getCluster().getLocalMember())) {
                HazelcastMsg hzMsg = (HazelcastMsg)msg.getMessageObject();
                LOG.info("{} received from hazelcast for topic {} message: {}", new Object[]{hzMsg.getClientId(), hzMsg.getTopic(), hzMsg.getPayload()});
                MqttQoS qos = MqttQoS.valueOf((int)hzMsg.getQos());
                MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, qos, false, 0);
                MqttPublishVariableHeader varHeader = new MqttPublishVariableHeader(hzMsg.getTopic(), 0);
                payload = Unpooled.wrappedBuffer((byte[])hzMsg.getPayload());
                MqttPublishMessage publishMessage = new MqttPublishMessage(fixedHeader, varHeader, payload);
                this.server.internalPublish(publishMessage, hzMsg.getClientId());
            }
        }
        catch (Exception ex) {
            LOG.error("error polling hazelcast msg queue", (Throwable)ex);
        }
        finally {
            ReferenceCountUtil.release(payload);
        }
    }
}

