/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server;

import io.moquette.server.config.IConfig;
import io.moquette.spi.security.ISslContextCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMoquetteSslContextCreator
implements ISslContextCreator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMoquetteSslContextCreator.class);
    private IConfig props;

    DefaultMoquetteSslContextCreator(IConfig props) {
        this.props = props;
    }

    @Override
    public SSLContext initSSLContext() {
        LOG.info("Checking SSL configuration properties...");
        String jksPath = this.props.getProperty("jks_path");
        LOG.info("Initializing SSL context. KeystorePath = {}.", (Object)jksPath);
        if (jksPath == null || jksPath.isEmpty()) {
            LOG.warn("The keystore path is null or empty. The SSL context won't be initialized.");
            return null;
        }
        String keyStorePassword = this.props.getProperty("key_store_password");
        String keyManagerPassword = this.props.getProperty("key_manager_password");
        if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            LOG.warn("The keystore password is null or empty. The SSL context won't be initialized.");
            return null;
        }
        if (keyManagerPassword == null || keyManagerPassword.isEmpty()) {
            LOG.warn("The key manager password is null or empty. The SSL context won't be initialized.");
            return null;
        }
        String sNeedsClientAuth = this.props.getProperty("need_client_auth", "false");
        boolean needsClientAuth = Boolean.valueOf(sNeedsClientAuth);
        try {
            LOG.info("Loading keystore. KeystorePath = {}.", (Object)jksPath);
            InputStream jksInputStream = this.jksDatastore(jksPath);
            SSLContext serverContext = SSLContext.getInstance("TLS");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(jksInputStream, keyStorePassword.toCharArray());
            LOG.info("Initializing key manager...");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyManagerPassword.toCharArray());
            TrustManager[] trustManagers = null;
            if (needsClientAuth) {
                LOG.warn("Client authentication is enabled. The keystore will be used as a truststore. KeystorePath = {}.", (Object)jksPath);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                trustManagers = tmf.getTrustManagers();
            }
            LOG.info("Initializing SSL context...");
            serverContext.init(kmf.getKeyManagers(), trustManagers, null);
            LOG.info("The SSL context has been initialized successfully.");
            return serverContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOG.error("Unable to initialize SSL context. Cause = {}, errorMessage = {}.", (Object)ex.getCause(), (Object)ex.getMessage());
            return null;
        }
    }

    private InputStream jksDatastore(String jksPath) throws FileNotFoundException {
        URL jksUrl = this.getClass().getClassLoader().getResource(jksPath);
        if (jksUrl != null) {
            LOG.info("Starting with jks at {}, jks normal {}", (Object)jksUrl.toExternalForm(), (Object)jksUrl);
            return this.getClass().getClassLoader().getResourceAsStream(jksPath);
        }
        LOG.warn("No keystore has been found in the bundled resources. Scanning filesystem...");
        File jksFile = new File(jksPath);
        if (jksFile.exists()) {
            LOG.info("Loading external keystore. Url = {}.", (Object)jksFile.getAbsolutePath());
            return new FileInputStream(jksFile);
        }
        LOG.warn("The keystore file does not exist. Url = {}.", (Object)jksFile.getAbsolutePath());
        return null;
    }
}

