/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.spi.IMatchingCondition;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.impl.subscriptions.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMessagesStore
implements IMessagesStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMessagesStore.class);
    private Map<Topic, IMessagesStore.StoredMessage> m_retainedStore = new HashMap<Topic, IMessagesStore.StoredMessage>();

    MemoryMessagesStore() {
    }

    @Override
    public void initStore() {
    }

    @Override
    public void storeRetained(Topic topic, IMessagesStore.StoredMessage storedMessage) {
        LOG.debug("Store retained message for topic={}, CId={}", (Object)topic, (Object)storedMessage.getClientID());
        if (storedMessage.getClientID() == null) {
            throw new IllegalArgumentException("Message to be persisted must have a not null client ID");
        }
        this.m_retainedStore.put(topic, storedMessage);
    }

    @Override
    public Collection<IMessagesStore.StoredMessage> searchMatching(IMatchingCondition condition) {
        LOG.debug("searchMatching scanning all retained messages, presents are {}", (Object)this.m_retainedStore.size());
        ArrayList<IMessagesStore.StoredMessage> results = new ArrayList<IMessagesStore.StoredMessage>();
        for (Map.Entry<Topic, IMessagesStore.StoredMessage> entry : this.m_retainedStore.entrySet()) {
            IMessagesStore.StoredMessage storedMsg = entry.getValue();
            if (!condition.match(entry.getKey())) continue;
            results.add(storedMsg);
        }
        return results;
    }

    @Override
    public void cleanRetained(Topic topic) {
        this.m_retainedStore.remove(topic);
    }
}

